<?php 
class WC_Gateway_Codepay_zfb extends WC_Payment_Gateway
{
    public function __construct() {
        // 必要的字段
        $this->id = 'codepay_zfb';
        $this->icon = WC_Freepay_URL.'/assets/logo/zfb-logo.jpg';
        $this->has_fields = false;
        $this->method_title = '码支付——支付宝';
        $this->method_description = '码支付——支付宝网关设置';
        
        // 必须调用的方法
        $this->init_form_fields();
        $this->init_settings();
        
        // 设置request或者response对象会用到的变量
        $this->title            = $this->get_option('title');
        $this->description      = $this->get_option('description');
        
        // 保存后台设置的数据
        add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );

        // 实例化异步通知的处理 
        new WC_Gateway_Codepay_Notify($this);
    }


     //配置列表项
    public function init_form_fields() {
        $this->form_fields = array(
            'enabled' => array(
                    'title'   => "启用/禁用",
                    'type'    => 'checkbox',
                    'label'   => "是否启用支付宝网关，默认为启用。",
                    'default' => 'yes',
            ),
            'title' => array(
                    'title'       => "标题",
                    'type'        => 'text',
                    'description' => '在结算时看到的当前支付方式的名称',
                    'default'     => '支付宝支付',
                    'desc_tip'    => true,
            ),
            'description' => array(
                    'title'       => '描述',
                    'type'        => 'text',
                    'desc_tip'    => true,
                    'description' => '结算时当前支付方式的描述',
                    'default'     => '本次交易将使用支付宝付款',
            )
            
        );
    }


    //核心订单处理
    public function process_payment($order_id)
    {
        global $woocommerce;
        $order = wc_get_order($order_id);
        $price = $order -> order_total;
        $type = 1;
        require("inc/codepay.config.php");  
        $parameter = array(
            "id" => (int)$data['id'],
            "pay_id" => $order_id,
            "type" => $type,
            "price" => (float)$price,
            "param" => $data['param'],
            "outTime" => $data["outTime"],
            "user_ip" => getIp(),
            "gateway" => $data['gateway'],
            "host" => $data['gateway'],
            "return_url" => plugin_dir_url( __FILE__ )."inc/codepay_return.php",
            //"notify_url" => "",
            "chart" => $data['chart'],
        );

        $url = create_link($parameter,$codepay_key);
        
         // add note for payment
        $msg = '顾客正在使用码支付-支付宝方式进行支付';
        $order->add_order_note($msg);

        $woocommerce->cart->empty_cart();      //清空购物车

        return array(
            'result'    =>  'success',
            'redirect'  =>  $url
        );

    }
}

  ?>
