<?php 
class WC_Gateway_Easypay_zfb extends WC_Payment_Gateway
{
    public function __construct() {
        // 必要的字段
        $this->id = 'easypay_zfb';
        $this->icon = WC_Freepay_URL.'/assets/logo/zfb-logo.jpg';
        $this->has_fields = false;
        $this->method_title = '易支付——支付宝';
        $this->method_description = '易支付——支付宝网关设置';
        
        // 必须调用的方法
        $this->init_form_fields();
        $this->init_settings();
        
        // 设置request或者response对象会用到的变量
        $this->title            = $this->get_option('title');
        $this->description      = $this->get_option('description');
        
        // 保存后台设置的数据
        add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );

        // 实例化异步通知的处理 
        new WC_Gateway_Easypay_Notify($this);
    }


     //配置列表项
    public function init_form_fields() {
        $this->form_fields = array(
            'enabled' => array(
                    'title'   => "启用/禁用",
                    'type'    => 'checkbox',
                    'label'   => "是否启用支付宝网关，默认为禁用。",
                    'default' => 'no',
            ),
            'title' => array(
                    'title'       => "标题",
                    'type'        => 'text',
                    'description' => '在结算时看到的当前支付方式的名称',
                    'default'     => '支付宝支付',
                    'desc_tip'    => true,
            ),
            'description' => array(
                    'title'       => '描述',
                    'type'        => 'text',
                    'desc_tip'    => true,
                    'description' => '结算时当前支付方式的描述',
                    'default'     => '本次交易将使用支付宝付款',
            )
            
        );
    }


    //核心订单处理
    public function process_payment($order_id)
    {
        global $woocommerce;
        $order = wc_get_order($order_id);
        $price = $order -> order_total;
        $order_items = $order->get_items();
        $product_num = count($order_items);
        foreach ($order_items as $item_id => $item_data) {
	        $product = $item_data->get_product();
	        $product_name = $product->get_name();
	        break;
	    }
        if ($product_num > 1)
        {
			$product_name .= "等".$product_num."件商品";
        }
        $type = "alipay";
        require("inc/easypay.config.php");
        require_once("lib/epay_submit.class.php");
        $parameter = array(
			"pid" => trim($alipay_config['partner']),
			"type" => $type,
			"notify_url"	=> plugin_dir_url( __FILE__ )."inc/easypay_return.php",
			"return_url"	=> home_url()."/wc-api/wc_gateway_easypay",
			"out_trade_no"	=> $order_id,
			"name" => $product_name,
			"money"	=> $price,
	);

        $alipaySubmit = new AlipaySubmit($alipay_config);
        // add note for payment
        $msg = '顾客正在使用易支付-支付宝方式进行支付';
        $order->add_order_note($msg);
        $woocommerce->cart->empty_cart();      //清空购物车
    	$para = urlencode(json_encode($alipaySubmit->payment_redirect($parameter)));
        return array(
            'result'    =>  'success',
            'redirect'  =>  plugin_dir_url( __FILE__ ).'payment_redirect.php?para='.$para
        );
    }
}
?>
