<?php 

require("codepay.config.php");
require("../lib/codepay_notify.class.php");

$codepayNotify = new CodepayNotify($data);
$verify_result = $codepayNotify->verifyAll(); //这里验证的是全部参数 这样软件端也能调试

if(!$verify_result)
{
    echo "fail";
    exit();
}

function DataHandle($data)
{
	$pay_id = $data['pay_id']; //需要充值的ID 或订单号 或用户名
    $money = (float)$data['money']; //实际付款金额
    $price = (float)$data['price']; //订单的原价
    $type = (int)$data['type']; //支付方式
    $pay_no = $data['pay_no']; //支付流水号
    $param = $data['param']; //自定义参数 原封返回 您创建订单提交的自定义参数
    $pay_time = (int)$data['pay_time']; //付款时间戳
    $pay_tag = $data['tag']; //支付备注 仅支付宝才有 其他支付方式全为0或空
    $creat_time = time(); //创建数据的时间戳

    if ($money <= 0 || empty($pay_id) || $pay_time <= 0 || empty($pay_no)) {
        echo '缺少必要的一些参数'; //测试数据中 唯一标识必须包含这些
        exit();
    }

    if ($price > $money)
    {
    	echo "付款金额过少";
    	exit();
    }

   header("location:" . $return_url);

}

DataHandle($_GET);



?>

